# Table 1 p-values (other values can be found by using np.sum and np.std)

# import packages
import pandas as pd
import numpy as np
import math
import pickle
import os, sys
import random
from scipy import stats

data0=pd.read_csv(r'X_data.csv' , header=None)
data1=pd.read_csv(r'X_data_sub1.csv' , header=None)
data2=pd.read_csv(r'X_data_sub2.csv' , header=None)
data3=pd.read_csv(r'X_data_sub3.csv' , header=None)

dt0=np.array(data0)
dt1=np.array(data1)
dt2=np.array(data2)
dt3=np.array(data3)

char0=dt0[:,[1,2,3,4,5,6,7,8,9,10,11]]
char1=dt1[:,[1,2,3,4,5,6,7,8,9,10,11]]
char2=dt2[:,[1,2,3,4,5,6,7,8,9,10,11]]
char3=dt3[:,[1,2,3,4,5,6,7,8,9,10,11]]

J=100 # 100 tests and take average
T1=np.zeros((J,11))
T2=np.zeros((J,11))
T3=np.zeros((J,11))

N0=char0.shape[0]
N1=char1.shape[0]
N2=char2.shape[0]
N3=char3.shape[0]
for j in range(1,J+1):
    np.random.seed(j)
    ys0=char0[np.random.permutation(N0)[0:int(np.ceil(N0*0.1))],:]
    ys1=char1[np.random.permutation(N1)[0:int(np.ceil(N1*0.1))],:]
    ys2=char2[np.random.permutation(N2)[0:int(np.ceil(N2*0.1))],:]
    ys3=char3[np.random.permutation(N3)[0:int(np.ceil(N3*0.1))],:]
    for k in range(1,12):
        t_stat1,p_val1=stats.ttest_ind(ys0[:,k-1],ys1[:,k-1])
        T1[j-1,k-1]=p_val1
        t_stat2,p_val2=stats.ttest_ind(ys1[:,k-1],ys2[:,k-1])
        T2[j-1,k-1]=p_val2
        t_stat3,p_val3=stats.ttest_ind(ys2[:,k-1],ys3[:,k-1])
        T3[j-1,k-1]=p_val3

TB=np.zeros((3,11))
TB[0,:]=np.mean(T1,axis=0)
TB[1,:]=np.mean(T2,axis=0)
TB[2,:]=np.mean(T3,axis=0)

with open('TAB1_pvalues.pkl','wb') as f:
    pickle.dump(TB,f)